package RISCOS::DrawFile::FontTable;
use Carp;

use strict;
use vars qw ($VERSION @ISA);

require RISCOS::DrawFile::Object;

@ISA = 'RISCOS::DrawFile::Object';
$VERSION = 0.02;
# 0.02 adds Translate

sub new ($$) {
    my $proto = shift;
    my $class = ref($proto) || $proto;

    my ($self, $type) = $class->SUPER::new;
    return $self if ref ($self) eq 'ARRAY';

    carp "Cannot make a Font Table of type $type" if defined $type and $type;

    my $old = {};
    my $new = {};
    # my $table = [];
    if (ref ($_[0]) eq 'ARRAY') {
	my $index = @{$_[0]};
	while ($index--) {
	    $old->{$index} = ${$_[0]}->[$index] if defined ${$_[0]}->[$index];
	}
    } elsif (ref ($_[0]) eq 'HASH') {
	$new->{''} = 0;		# System font is stored as '' and font number 0
	delete $_[0]->{''};
	my $index = 0;
	foreach (keys %{$_[0]}) {
	    # If more than zero are using it, assign it a table entry
	    $new->{$_} = ++$index if $_[0]->{$_};
	#    $table[$index] = $_;
	}
	carp "Aaaargh - can't make a fonttable with $index entries (design limit of DrawFiles is 255)" if $index > 255;
    } else {
	$_ = substr $_[0], 8;
	while (s/^(.)([^\0]+)\0//s)
	{
	    $old->{ord $1} = $2;
	}
	carp "Spurious text '$_' at end of Font Table" unless /^\0{0,4}$/;
    }
    $self->{'__OLD'} = $old;
    $self->{'__NEW'} = $new;
    # $self->{'__TABLE'} = $table;
    wantarray ? ([], 0, $self) : $self;	# We are a FontTable!
}

sub BBox {
    undef;
}

\&BBox_Calc = \&BBox;

sub Translate {
}

sub Pack {
carp 'um';
    my $self = shift;
#    my $zeroth = shift @$self;
#    my $result = $self->PackType() . $self->Size() . join ("\0", @$self, '');
#    unshift @$self, $zeroth;
#    $result . "\0" x ((length $result + 3) & ~3);
}

sub Size {
    my $self = shift;
    my $new = $self->{'__NEW'};
    my $size = 8;
    foreach (keys %$new) {
        next unless $_;
        $size += 2 + length $_;
    }
    ($size + 3) & ~3;
}

sub Write {
    my $self = shift;
    my $new = $self->{'__NEW'};
    my $size = $self->Size;
    return unless $size > 8;	# Don't do a blank fonttable
    print {$_[0]} pack 'I2', 0, $size;
    $size -= 8;
    foreach (keys %$new) {
        next unless $_;
        print {$_[0]} pack 'Ca*x', $new->{$_}, $_;
        $size -= 2 + length $_;
    }
    print {$_[0]} "\0" x $size;
}

sub Type {
    0;
}

sub FontByNumber {
    my $self = shift;
    my $old = $self->{'__OLD'};
    return $old->{$_[0]} unless wantarray;
    map  { $old->{$_} } @_;
}

sub NameToNumber {
    my $self = shift;
    my $what = $self->{'__NEW'}->{$_[0]};
    carp "Font name lookup failed for '$_[0]'" unless $what;
    # use Data::Dumper;
    # print STDERR Dumper \$self unless $what;
    $what;
}
1;
__END__

=head1 NAME

RISCOS::DrawFile::FontTable

=head1 SYNOPSIS

Class to handle font tables in DrawFiles

=head1 DESCRIPTION

C<RISCOS::DrawFile::FontTable> packs and unpacks fonttables for
C<RISCOS::DrawFile>. As C<RISCOS::DrawFile::Text> objects hold their font
information internally you should never need to know about Font tables.

=head1 BUGS

Not tested enough.

=head1 AUTHOR

Nicholas Clark <F<nick@unfortu.net>>
